<?php
/*--------------------------------------------------------------
   StatisticsDataService.php 2021-08-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Services;

use DateTimeInterface;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial;

/**
 * @todo Refactor.
 */
interface StatisticsDataService
{
    /**
     * Get orders as serial data for provided time span.
     */
    public function getOrdersByTimespan(DateTimeInterface $start, DateTimeInterface $end): Serial;
    
    
    /**
     * Get conversion rates as serial data for provided time span.
     */
    public function getConversionRatesByTimespan(DateTimeInterface $start, DateTimeInterface $end): Serial;
    
    
    /**
     * Get sales as serial data for provided time span.
     */
    public function getSalesByTimespan(DateTimeInterface $start, DateTimeInterface $end): Serial;
    
    
    /**
     * Get visitors as serial data for provided time span.
     */
    public function getVisitorsByTimespan(DateTimeInterface $start, DateTimeInterface $end): Serial;
}